/*
 * Decompiled with CFR 0.152.
 */
package GlomoReg;

import GlomoReg.GlomoConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.microedition.midlet.MIDlet;

public class GlomoUtil {
    private static Random rand = new Random();
    private static String hexChars = "0123456789ABCDEF";
    private static String base36Chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static final String[] split(String string, String string2) {
        System.out.println("=== split: separator=" + string + " str=" + string2);
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        n3 = 0;
        while ((n3 = string2.indexOf(string, n3) + 1) > 0) {
            ++n2;
        }
        String[] stringArray = new String[n2];
        n2 = 0;
        n3 = 0;
        while ((n3 = string2.indexOf(string, n3) + 1) > 0) {
            stringArray[n2] = string2.substring(n4, n3 - 1);
            ++n2;
            n4 = n3 - 1 + string.length();
        }
        stringArray[n2] = string2.substring(n4);
        return stringArray;
    }

    public static final String format(String string, String[] stringArray) {
        return GlomoUtil.format(string, stringArray, '%');
    }

    public static final String format(String string, String[] stringArray, char c2) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == c2) {
                if (i2 + 1 < string.length() && string.charAt(i2 + 1) == c2) {
                    stringBuffer.append(c3);
                    ++i2;
                    continue;
                }
                stringBuffer.append(stringArray[n2++]);
                continue;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public static final String[] format(String[] stringArray, String[][] stringArray2) {
        String[] stringArray3 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray3[i2] = GlomoUtil.format(stringArray[i2], stringArray2[i2]);
        }
        return stringArray3;
    }

    public static final int getCheckSum(String string) {
        return GlomoUtil.getCheckSum(string, 0, 0);
    }

    public static final int getCheckSum(String string, int n2) {
        return GlomoUtil.getCheckSum(string, n2, 0);
    }

    public static final int getCheckSum(String string, int n2, int n3) {
        int n4 = 0;
        if (n3 == 0) {
            for (int i2 = n2; i2 < string.length(); ++i2) {
                n4 = ((n4 << 1 | (n4 & 0x80) >> 7) & 0xFF ^ string.charAt(i2) & 0xFF) & 0xFF;
            }
        }
        return n4;
    }

    public static final String extractCheckSum(String string, String string2) {
        int n2 = string2.indexOf(string);
        return n2 >= 0 ? string2.substring(0, n2 - 1) : string2;
    }

    public static String[] readResourceAsArr(MIDlet mIDlet, String string) {
        return GlomoUtil.readResourceAsArr(mIDlet, string, true);
    }

    public static String[] readResourceAsArr(MIDlet mIDlet, String string, boolean bl2) {
        return GlomoUtil.split("\n", GlomoUtil.readResource(mIDlet, string, bl2));
    }

    public static String readResource(MIDlet mIDlet, String string) {
        return GlomoUtil.readResource(mIDlet, string, true);
    }

    public static String readResource(MIDlet mIDlet, String string, boolean bl2) {
        try {
            int n2;
            InputStream inputStream = mIDlet.getClass().getResourceAsStream(string);
            String string2 = "";
            char[] cArray = new char[inputStream.available() / 2 - 1];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n2);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.readChar();
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                cArray[i2] = dataInputStream.readChar();
            }
            dataInputStream.close();
            dataInputStream = null;
            byteArrayInputStream.close();
            byteArrayInputStream = null;
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            string2 = new String(cArray);
            String string3 = GlomoUtil.decrypt(string2, 0);
            return bl2 ? GlomoUtil.decrypt(string2, 0) : string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final int rnd(int n2, int n3) {
        int n4 = Math.abs(rand.nextInt());
        return n4 % (n3 - n2) + n2;
    }

    public static final long generateRandomKey(int n2) {
        if (n2 == 0) {
            int n3 = Integer.parseInt(GlomoConfig.distInfo.smsKeyVersion());
            int n4 = n3 == 0 ? 6 : 6;
            int n5 = 1;
            int n6 = 9;
            for (int i2 = 0; i2 < n4 - 1; ++i2) {
                n5 *= 10;
                n6 = n6 * 10 + 9;
            }
            return GlomoUtil.rnd(n5, n6);
        }
        return 0L;
    }

    public static final String generateKeyOfType(int n2, String string, long l2) {
        if (GlomoConfig.versionInt() > 1) {
            int n3 = Integer.parseInt(GlomoConfig.distInfo.smsKeyVersion());
            String string2 = GlomoConfig.distInfo.channelId();
            String string3 = string2.substring(0, 2);
            String string4 = string2.substring(2, 5);
            return string + string3 + GlomoUtil.encryptLight(GlomoUtil.toBase36((l2 != 0L ? l2 : GlomoUtil.generateRandomKey(0)) * 10000L + Long.parseLong(string4) * 10L + (long)(n2 % 10), n3 == 0 ? 7 : 7), 2) + GlomoConfig.sms_key_version().substring(0, 1);
        }
        return string + GlomoConfig.distInfo.channelId() + GlomoUtil.encryptLight(GlomoUtil.toBase36((l2 != 0L ? l2 : GlomoUtil.generateRandomKey(0)) * 10000L + Long.parseLong(GlomoConfig.distInfo.id()) * 10L + (long)(n2 % 10), 7), 2) + GlomoConfig.sms_key_version().substring(0, 1);
    }

    public static byte[] encryptLightByte(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[byArray.length];
        if (n2 == 0) {
            int n3;
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray2[(n3 + 5) % byArray.length] = (byte)(0x25 ^ byArray[n3]);
            }
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray2[n3] = (byte)(byArray2[n3] ^ byArray2[(n3 + 2) % byArray.length]);
            }
        }
        return byArray2;
    }

    public static byte[] decryptLightByte(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[byArray.length];
        if (n2 == 0) {
            int n3;
            for (n3 = byArray.length - 1; n3 >= 0; --n3) {
                byArray[n3] = (byte)(byArray[n3] ^ byArray[(n3 + 2) % byArray.length]);
            }
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray2[n3] = (byte)(0x25 ^ byArray[(n3 + 5) % byArray.length]);
            }
        }
        return byArray2;
    }

    public static byte[] packDigits(String string) {
        if (string.length() % 2 == 1) {
            string = string + "0";
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)(Byte.parseByte(string.substring(i2 * 2, i2 * 2 + 1)) + (byte)(Byte.parseByte(string.substring(i2 * 2 + 1, i2 * 2 + 2)) << 4));
        }
        return byArray;
    }

    public static String unpackDigits(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append(String.valueOf(hexChars.charAt(byArray[i2] & 0xF)));
            stringBuffer.append(String.valueOf(hexChars.charAt(byArray[i2] >> 4 & 0xF)));
        }
        return stringBuffer.toString();
    }

    public static String encryptLight(String string, int n2) {
        if (string.length() == 0) {
            return string;
        }
        if (n2 == 0) {
            return new String(GlomoUtil.encryptLightByte(string.getBytes(), n2));
        }
        if (n2 == 1) {
            return GlomoUtil.unpackDigits(GlomoUtil.encryptLightByte(GlomoUtil.packDigits(string), 0));
        }
        if (n2 == 2 && string.length() > 2) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 2));
            for (int i2 = 0; i2 < string.length() - 2; ++i2) {
                stringBuffer.append(string.charAt(2 + (i2 + base36Chars.indexOf(string.charAt(1))) % (string.length() - 2)));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String decryptLight(String string, int n2) {
        if (n2 == 0) {
            return new String(GlomoUtil.decryptLightByte(string.getBytes(), n2));
        }
        if (n2 == 1) {
            return GlomoUtil.unpackDigits(GlomoUtil.decryptLightByte(GlomoUtil.packDigits(string), 0));
        }
        if (n2 == 2 && string.length() > 2) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 2));
            int n3 = string.length() - 2;
            for (int i2 = 0; i2 < n3; ++i2) {
                stringBuffer.append(string.charAt(2 + (i2 + n3 - base36Chars.indexOf(string.charAt(1)) % n3) % n3));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String toBase36(long l2, int n2) {
        StringBuffer stringBuffer = new StringBuffer("");
        while (l2 > 0L) {
            stringBuffer.append(base36Chars.charAt((int)(l2 % 36L)));
            l2 /= 36L;
        }
        while (stringBuffer.length() < n2) {
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    public static long fromBase36(String string) {
        long l2 = 0L;
        long l3 = 1L;
        int n2 = 0;
        while (n2 < string.length()) {
            l2 += l3 * (long)base36Chars.indexOf(string.charAt(n2));
            ++n2;
            l3 *= 36L;
        }
        return l2;
    }

    public static String decrypt(String string, int n2) {
        int n3;
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n4 = cArray.length + 1;
        int n5 = 1;
        int n6 = 1;
        int n7 = 0;
        for (n3 = 1; n3 < n4; ++n3) {
            cArray2[n3 - 1] = cArray[n3 - 1];
        }
        n5 = 1;
        while (n5 < n4) {
            n6 >>= 1;
            n5 = n5 << 1 | 1;
        }
        for (int i2 = n4 - (n5 >>= 1); i2 > 0; i2 -= cArray.length - n5 + (cArray.length - n5 > 0 ? 0 : 1)) {
            int n8 = 0;
            for (int i3 = 4; i3 <= n5 + 1 << 1; i3 += 2) {
                n3 = 0;
                n7 = 0;
                int n9 = 0;
                n6 = 1;
                int n10 = n5 + 1 >> 1;
                while (n3 <= n8) {
                    int n11;
                    if (n3 < n8 || (i3 >> 1) - 2 + (n8 << 1) - n7 - (n5 >> 1) > 0) {
                        n11 = n9 + ((((i3 >> 1) - 2 & n6) == 0 ? 1 : -1) * (n10 >> 1) + 2);
                    } else {
                        int n12;
                        char c2;
                        int n13 = i2 + (i3 >> 1) - 3;
                        char c3 = cArray2[i2 + (i3 >> 1) - 3];
                        cArray2[i2 - 1 - (n8 << 1) + n7 + (n5 >> 1)] = c3;
                        char c4 = cArray2[n13] = (char)(cArray2[n13] + (cArray2[i2 - 1 - (n8 << 1) + n7 + (n5 >> 1)] - c3));
                        if ((i3 >> 1) + (n8 << 1) - (n5 >> 1) - n7 - 2 == 0) {
                            c2 = '\u0000';
                        } else {
                            n12 = cArray2[i2 + (i3 >> 1) - 3] + 142;
                            c2 = cArray2[i2 + (i3 >> 1) - 3] = (char)((n12 % 10 + 10 + (i2 - 3) % 10) % 10 + n12 / 10 * 10 - 142);
                        }
                        n12 = cArray2[i2 - 1 - (n8 << 1) + n7 + (n5 >> 1)] + 142;
                        char c5 = (char)((n12 % 10 + 10 + (i2 - 3) % 10) % 10 + n12 / 10 * 10 - 142);
                        cArray2[i2 - 1 - (n8 << 1) + n7 + (n5 >> 1)] = c5;
                        n11 = c4 + c2 + c5;
                    }
                    n7 = n11;
                    ++n3;
                    n6 <<= 1;
                    n10 >>= 1;
                }
                n8 += i3 >> 1 == 2 << n8 ? 1 : 0;
            }
        }
        for (n3 = 1; n3 < n4; ++n3) {
            cArray[n3 - 1] = cArray2[n3 - 1];
        }
        return new String(cArray);
    }

    public static String dateToString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = calendar.get(1);
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        int n8 = calendar.get(14);
        return n2 + "-" + (n3 <= 10 ? "0" : "") + n3 + "-" + (n4 <= 10 ? "0" : "") + n4 + " " + (n5 <= 10 ? "0" : "") + n5 + ":" + (n6 <= 10 ? "0" : "") + n6 + ":" + (n7 <= 10 ? "0" : "") + n7 + "." + n8;
    }

    public static final String JAD(MIDlet mIDlet, String string) {
        try {
            String string2;
            String string3 = string2 = mIDlet.getAppProperty(string) == null ? "" : mIDlet.getAppProperty(string);
            if (string2.charAt(string2.length() - 1) == ';') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }
}

